//  Created by Mario Geneau on 10/16/25.

import SwiftUI

struct ContentView: View {
  @State private var angle: Double = 0
  
  var body: some View {
    VStack {
      Image(systemName: "globe")
        .font(.system(size: 200))
        .foregroundStyle(.tint)
        .padding(.leading, 100)
        .rotation3DEffect(.degrees(angle), axis: (x: 1, y: 1, z: 1), anchor: .leading)
        .onAppear {
          withAnimation(.linear(duration: 4).repeatForever(autoreverses: false)) {
            angle = 360
          }
        }
    }
    .padding()
  }
}

#Preview {
  ContentView()
}
