import SwiftUI

struct ContentView: View {
  @State private var scoreTracker: [String] = []
  @State private var Mario: (() -> Void)?
  @State private var Gab: (() -> Void)?
  
  func makeTaggedCounter(tag: String) -> () -> Void {
    var count = 0
    return {
      count += 1
      scoreTracker.append("\(tag): \(count)")
    }
  }
  
  var body: some View {
    VStack(spacing: 12) {
      HStack {
        Button("Mario scores", action: Mario ?? {})
        Button("Gab scores", action: Gab ?? {})
      }
      .buttonStyle(.borderedProminent)
      
      //  List(data, id: howToTellItemsApart) { buildRow(for: eachItem) }
      List(scoreTracker, id: \.self) { Text($0) }
        .frame(maxHeight: .infinity)
    }
    .padding()
    .onAppear {
      Mario = makeTaggedCounter(tag: "Mario")
      Gab = makeTaggedCounter(tag: "Gab")
    }
  }
}

#Preview { ContentView() }
