import SwiftUI
import Combine

@MainActor
class FetchJsonModel: ObservableObject {
  @Published var posts: [Post] = []
  @Published var errorMessage: String?

  func fetchPosts(urlToFetch: String) async {
    let url = URL(string: urlToFetch)!
    do {
      let (data, response) = try await URLSession.shared.data(from: url)
      guard let httpResponse = response as? HTTPURLResponse,
            200..<300 ~= httpResponse.statusCode else {
        throw URLError(.badServerResponse)
      }
      posts = try JSONDecoder().decode([Post].self, from: data)
    } catch {
      errorMessage = "Failed to load posts: \(error.localizedDescription)"
    }
  }
}

// MARK: Mario Geneau - 10/1/25 - v1
